<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );
	wp_enqueue_style( 'main-custom-css', get_stylesheet_directory_uri() . '/custom-css/main.css');
    
   wp_enqueue_style( 'main-custom-fonts', get_stylesheet_directory_uri() . '/custom-fonts/main-fonts.css');

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );



/*poner editor antiguo*/

add_filter( 'use_block_editor_for_post', '__return_false' );

//plugin prevent cache, crea versiones diferentes de los estilos y js
prevent_browser_caching( array( 
    'assets_version' => 'febrero-19-2023' 
) );